//File modified by @CrisXolt.
// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300

#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
_centroid in highp vec2 uv;
#else
_centroid in vec2 uv;
#endif

#else

varying vec2 uv;
#endif

#include "uniformShaderConstants.h"
#include "uniformPerFrameConstants.h"
#include "util.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;

void main()
{
#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE)
	vec4 diffuse = texture2D( TEXTURE_0, uv );
#else
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv );
#endif

#ifdef ALPHA_TEST
	if(diffuse.a < 0.5)
		discard;
#endif

	gl_FragColor = CURRENT_COLOR * diffuse;

#ifdef CUBEMAP

float DST = mix(1.0,0.0,pow(max(min(1.0-FOG_COLOR.r*1.5,1.0),0.0),1.2));
float SST = clamp((CURRENT_COLOR.b-0.15)*1.0764706,0.0,1.0);

float TD = (DST);
float TS = (0.5-abs(0.40-SST*1.00));
float TN = (1.0-DST);
float WR = (1.20-clamp(3.34*(FOG_CONTROL.y-0.7),0.0,1.0));

vec2 CMDT = vec2(0.500,0.500);
vec2 CMNT = vec2(0.500,0.0);
vec2 CMST = vec2(0.0,0.500);

vec4 D = texture2D(TEXTURE_0,uv.xy*CMDT);
vec4 N = texture2D(TEXTURE_0,uv.xy*CMDT+CMNT);
vec4 S = texture2D(TEXTURE_0,uv.xy*CMDT+CMST);

D = D * 1.9;
N = N * 1.125;
S = S * 3.0;

D = D * TD;
N = N * TN;
S = S * TS;

vec4 DN = (1.0-N.a)*D+N.a*N;
vec4 CMC = (1.0-S.a)*DN+S.a*S;
CMC -= CMC*WR;

gl_FragColor = CMC;

#endif
}
